/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.experience.calculation.condition;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.calculation.condition.Condition;
import net.puffish.skillsmod.api.experience.calculation.condition.ConditionFactory;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.utils.JsonParseUtils;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.api.utils.failure.Failure;
import net.puffish.skillsmod.api.utils.failure.ManyFailures;

public final class ItemCondition
implements Condition<ItemStack> {
    private final Item item;
    private final Optional<NbtPredicate> optNbt;

    public ItemCondition(Item item, Optional<NbtPredicate> optNbt) {
        this.item = item;
        this.optNbt = optNbt;
    }

    public static ConditionFactory<ItemStack> factory() {
        return ConditionFactory.withData(ItemCondition::parse);
    }

    public static Result<ItemCondition, Failure> parse(JsonElementWrapper rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(ItemCondition::parse);
    }

    public static Result<ItemCondition, Failure> parse(JsonObjectWrapper rootObject) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional optItem = rootObject.get("item").andThen(JsonParseUtils::parseItem).ifFailure(failures::add).getSuccess();
        Optional<NbtPredicate> optNbt = rootObject.get("nbt").getSuccess().flatMap(stateElement -> JsonParseUtils.parseNbtPredicate(stateElement).ifFailure(failures::add).getSuccess());
        if (failures.isEmpty()) {
            return Result.success(new ItemCondition((Item)optItem.orElseThrow(), optNbt));
        }
        return Result.failure(ManyFailures.ofList(failures));
    }

    @Override
    public boolean test(ItemStack itemStack) {
        return itemStack.m_150930_(this.item) && this.optNbt.map((? super T nbt) -> nbt.m_57479_(itemStack)).orElse(true) != false;
    }
}

